package gov.va.genisis2.dao;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.CommentType;
import gov.va.genisis2.model.DataType;
import gov.va.genisis2.model.FieldToolTipDescription;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;


public interface ILookUpDao {
	public int getStatusId(String statusDescription) throws GenisisDAOException;

	public RequestType getRequestType(int id) throws GenisisDAOException;

	public Source getSource(int id) throws GenisisDAOException;

	public List<Source> getDataSources() throws GenisisDAOException;

	public List<RequestType> getRequestTypes() throws GenisisDAOException;
	
	public CommentType getCommentType(int id) throws GenisisDAOException;
	
    public List<DataType> getDataTypes() throws GenisisDAOException;
	
	public DataType getDataType(int id) throws GenisisDAOException;
	
	public List<StudyApproval> getStudyApprovalsByRole(int id) throws GenisisDAOException;
	
	public FieldToolTipDescription getTooltipDescription(String fieldName) throws GenisisDAOException;
	
	
	
	
}
